/*---------------------------------------------------------------------------*/
/*                                                                           */
/* FILE:    usecvidll.c                                                      */
/*                                                                           */
/* PURPOSE: This project demonstrates how to call into a simple 32-bit DLL in*/
/*          LabWindows/CVI.  In order for the exported functions*/
/*          to link properly, you will need to add the DLL import library    */
/*          for the DLL to your project.  The import library will be         */
/*          generated by Labwindows/CVI when you build the cvidll project.   */
/*                                                                           */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Include files                                                             */
/*---------------------------------------------------------------------------*/
#include <cvirte.h>  
#include "cvidll.h" /* Notice we need the DLL function prototypes */
#include <userint.h>
#include <ansi_c.h>



int DIValue;
int err;

/*---------------------------------------------------------------------------*/
/* This is the application's entry-point.                                    */
/*---------------------------------------------------------------------------*/
int main (int argc, char *argv[])
{
    char message[100];
    
    if (InitCVIRTE (0, argv, 0) == 0) 
        return -1; 
    
    err = OpenAndInit ("kpcipio",0);  // call Open and Init for device 0
    
    /*
      Pass the name of your driver to avoid the OpenDriverLINX Dialog box
      KPCI-3107/8 : kpci3108
      KPCI-3101/2/3/4 or KPCI-3116/10: kpci3100
      KPCI-PIOxx : kpcipio
      KPCI-3160:  kpci3160
      KPCI-PDISO/PIO32 : kpciiso
      ISA PIO cards:  kmbpio
    
    */
    if (err == 0)  // if no error on OpenAndInit, proceed to read DI channel
    {   // no error on OpenAnd Init
        DIValue = ReadDI (0);  // read DI channel 0
    
        if (DIValue == -1)
        {  // error conditon on ReadDI
      	 sprintf (message, "Verify your board has the DI channel requested.");
         MessagePopup ("Error Reading DI Value", message);
        } else
        { 
        sprintf (message, "DIValue returned %d", DIValue);
        MessagePopup ("Using a DLL writen in CVI", message);
        }
    } else  // error on OpenAndInit
    
    {
     sprintf (message, "Check for installed DriverLINX device. \r Verify Device Number used.");
     MessagePopup ("Error on Initialization", message);
    }
    
    CloseDriver();  // close driver on exit
    
    CloseCVIRTE ();
    return 0;
}
